﻿using System;
using System.Globalization;
using System.IO;

namespace SoftPi.Tariscope.WebAdministration.Scripts
{
    public class Ua_Ukrtelecom : IScript
    {
        private IScriptHost host;
        private IScriptDatabaseHelper databaseHelper;

        public void Init(IScriptHost host, IScriptDatabaseHelper dbHelper)
        {
            this.host = host;
            this.databaseHelper = dbHelper;
        }

        public void Main(object parameters)
        {
            var CurrentDN = string.Empty;
            string NumberA;
            string NumberB;
            DateTime RecDateTime;
            int RecDuration;
            int CallUkrType;
            string RecZone;
            string RecTrunk;
            decimal RecCost;

            const int DNLENGTH = 7;
            const string OutCityCode = "0";

            var lines = File.ReadAllLines(parameters.ToString());

            foreach (var currentLine in lines)
            {
                if (host.IsCancelling)
                    return;

                if (currentLine.Length > 0)
                {
                    NumberA = currentLine.Substring(1, 14).Trim();

                    if (NumberA.Length > DNLENGTH && DNLENGTH > 0)
                        NumberA = NumberA.Substring(NumberA.Length - DNLENGTH + 1);

                    RecDateTime = DateTime.ParseExact(
                        currentLine.Substring(15, 14), 
                        "yyyyMMddHHmmss", 
                        CultureInfo.InvariantCulture);

                    CallUkrType = int.Parse(currentLine.Substring(30, 1));

                    NumberB = currentLine.Substring(32, 20).Trim();
                    RecZone = currentLine.Substring(52, 10).Trim();

                    if (NumberB.StartsWith(RecZone)) {}
                    else
                    {
                        if (RecZone.Length == 3 && NumberB.Length == 6)
                            RecZone += "2";
                        else if (NumberB[..2] == RecZone[^2..])
                            RecZone = RecZone[..^2];
                        else if (NumberB[0] == RecZone[^1])
                            RecZone = RecZone[..^1];
                        else if (NumberB.StartsWith(OutCityCode + RecZone)) {
                            RecZone = string.Empty;
                            NumberB = NumberB[1..];
                        }
                        NumberB = RecZone + NumberB;
                    }

                    RecDuration = int.Parse(currentLine.Substring(75, 6));
                    RecCost = 0;
                    RecCost = decimal.Parse(currentLine.Substring(93, 12), NumberStyles.Number, CultureInfo.InvariantCulture);
                    RecTrunk = currentLine.Substring(105, 6).Trim();

                    var callModel = new CallModel()
                    {
                        CallDateTime = RecDateTime,
                        Cost = RecCost,
                        CallDuration = RecDuration,
                        RecordType = Common.RecordTypeEnum.Imported,
                        //TODO
                    };

                    //host.AddCall(callModel);
                }
            }
        }
    }
}
